%This script tests the static method format_struct
function test_suite = testFormatStruct %#ok<*STOUT>
initTestSuite;

function testEmptyStruct %#ok<*DEFNU>
out = BertiniLab.format_struct(struct([]));
assertEqual(out,{})

function testNumericalValue
out = BertiniLab.format_struct(struct('a',1));
assertEqual(out,{'a','1'})

function testPolysymValue
out = BertiniLab.format_struct(struct('a',polysym('1')));
assertEqual(out,{'a','1'})

function testPolysymRow
s = struct('variable_group',polysym({'x','y'}));
out = BertiniLab.format_struct(s);
assertEqual(out,{'variable_group','x, y'})

function testPolysymColumn
s = struct('variable_group',polysym({'x';'y'}));
out = BertiniLab.format_struct(s);
assertEqual(out,{'variable_group','x, y'})

function testCellstrRow
s = struct('variable_group',{{polysym('x'), polysym('y')}});
out = BertiniLab.format_struct(s);
assertEqual(out,{'variable_group','x'; 'variable_group','y'})

function testCellstrColumn
s = struct('variable_group',{{polysym('x'); polysym('y')}});
out = BertiniLab.format_struct(s);
assertEqual(out,{'variable_group','x'; 'variable_group','y'})

function testCellstrTwoD
s = struct('variable_group',{{polysym('x') polysym('y'); polysym('z') polysym('w')}});
out = BertiniLab.format_struct(s);
assertEqual(out,{'variable_group','x'; 'variable_group','z'; ...
    'variable_group','y'; 'variable_group','w'})

function testInvalidType
f = @() BertiniLab.format_struct(struct('variable','x'));
assertExceptionThrown(f,'BertiniLab:format_struct:invalidType')